import os
from disk.admin.monitors.common.pg_client import PgClient
from disk.admin.monitors.common.juggler import send_juggler

queries = {
    'staleWaitDnsEntries': {
        'query': 'select count(1) as cnt from mail_users_domains where status = \'wait_dns_entries\' and updated_at < now() - interval \'{threshold}\' and id > 90000',
        'limit': 0,
        'threshold': '1 day',
    },
    'staleExpiredAt': {
        'query': 'select count(1) as cnt from mail_users_domains where expired_at is null and updated_at <= now() - interval \'{threshold}\' and status not in (\'failed\', \'cancelled_by_user\') and uid not in (\'1447609217\', \'1447609508\', \'1447609860\', \'1447610229\', \'1447610685\')',
        # Игнорим uid'ы, т.к. для них ничего не покупается, они тестовые (https://st.yandex-team.ru/MOBILEMAIL-18611#6114deac5a3e20776a18fdfc)
        'limit': 0,
        'threshold': '1 day',
    },
    'noProlongDomains': {
        'query': 'select count(*) as cnt from mail_users_domains where expired_at <= now() + interval \'{threshold}\' and status not in (\'failed\', \'cancelled_by_user\')',
        'limit': 0,
        'threshold': '30 days',
    },
    'manyFailedDomainsInLast10Records': {
        'query': 'select count(*) from (select status from mail_users_domains order by id desc limit {query_limit}) as t where status = \'failed\'',
        'limit': 5,
        'query_limit': 10,
    },
    'manyCancelledByUserDomainsInLast10Records': {
        'query': 'select count(*) from (select status from mail_users_domains order by id desc limit {query_limit}) as t where status = \'cancelled_by_user\'',
        'limit': 5,
        'query_limit': 10,
    },
    'manyFailedDomainsByLastDay': {
        'query': 'select count(*) from mail_users_domains where status = \'failed\' and created_at >= now() - interval \'{threshold}\'',
        'limit': 50,
        'threshold': '1 day',
    },
}

def main():
    pg_client = PgClient(
        os.getenv('PG_GROUP', 'db_mdbgpsshncm9lq1jt9pd').strip('%'),
        os.getenv('PG_USER'),
        os.getenv('PG_PASS'),
        os.getenv('PG_DB', 'db1'),
        os.getenv('PG_PORT', '6432')
    )

    for query in queries:
        result = pg_client.execute(
            queries[query]['query'].format(**queries[query]),
            lambda r: r.fetchall()[0],
            list,
            keep_shard=False,
            replica_only=True
        )[0][0]

        limit = queries[query]['limit']

        if result > limit:
            send_juggler('domenator', query, 'CRIT', '{} > {}'.format(result, limit))
        else:
            send_juggler('domenator', query, 'OK', '{} <= {}'.format(result, limit))

if __name__ == '__main__':
    main()
