#!/usr/bin/env python2.7
# -*- encoding: utf-8 -*-

try:
    from infra.yasm.yasmapi import GolovanRequest
except:
    from yasmapi import GolovanRequest
from disk.admin.monitors.common.juggler import send_juggler
import argparse
import time
from datetime import datetime

HOST = "ASEARCH"
ITYPE = 'deploy'
METRIC_NAME = 'unistat-stat-manager_limit_numberOfLimitedToday_max'
STAGE = 'disk-download-stat-stable'

DAY = 86400
DEFAULT_PERIOD = 300


def get_signal(metric, stage=STAGE, itype=ITYPE):
    return "itype=%s;stage=%s:%s" % (itype, stage, metric)


def get_signal_max_value(signal, start_time, period=DEFAULT_PERIOD):
    max_tries = 3
    for n_try in range(max_tries):
        try:
            return max([value[1].get(signal) for value in
                        GolovanRequest(HOST, period, start_time - period, start_time, [signal])])
        except Exception as e:
            if n_try < max_tries - 1:
                time.sleep(5)
                continue
            raise e


def to_juggler(status, message):
    send_juggler('disk_download_stat', 'check_number_of_limited_files', status, message)


def send_ok():
    to_juggler('OK', 'OK')


def send_crit(message):
    to_juggler('CRIT', message)


def check_alert(diff):
    signal = get_signal(METRIC_NAME)
    now = int(time.time())
    yesterday = now - DAY

    now_value = get_signal_max_value(signal, now)
    yesterday_value = get_signal_max_value(signal, yesterday)

    if now_value is None or yesterday_value is None:
        send_crit('value for golovan signal "%s" not found' % METRIC_NAME)
        return

    if yesterday_value - now_value > diff:
        send_crit('{0} - {1} > {2};\n{1} files limited now; {0} files limited yesterday;'
                  .format(now_value, yesterday_value, diff))
        return

    send_ok()

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-d', '--diff', default=30000, type=int, help='Max diff between now and yesterday values')
    parser.add_argument('--start_hour', default=11, type=int, help='Hour of the start of inspection')
    parser.add_argument('--end_hour', default=20, type=int, help='Hour of the end of inspection')

    args = parser.parse_args()
    hour = datetime.now().hour

    if args.start_hour <= hour <= args.end_hour:
        check_alert(args.diff)
    else:
        send_ok()

if __name__ == '__main__':
    main()
