#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import sys
from os import getenv
import logging
from dtrace.report import *

logger = logging.getLogger(__name__)

if __name__ == '__main__':
    logging.basicConfig(stream=sys.stdout, level=logging.ERROR)
    logger.setLevel(logging.DEBUG)
    ycrid = getenv('DTRACE_YCRID')
    uid, date = getenv('DTRACE_UID'), getenv('DTRACE_DATE')
    yql_token = getenv('YQL_TOKEN')
    idd_yt_path = getenv('IDD_YT_PATH')
    yt_root = getenv('YT_ROOT')
    output = getenv('DTRACE_OUT')

    assert date

    if len(sys.argv) > 1:
        if sys.argv[1] == 'uid':
            assert uid
            app = UIDTrace(uid, date, yql_token)
            report = app.report()
            print ('==Report for uid %s (%s)' % (uid, date))
            lines = report.common_as_text()
            print('\n'.join(lines))
        elif sys.argv[1] == 'ycrid':
            assert ycrid
            app = YCRIDTrace(ycrid, date, yql_token)
            report = app.report()
            print ('==Report for ycrid %s (%s)' % (ycrid, date))
            lines = report.common_as_text()
            print('\n'.join(lines))
        elif sys.argv[1] == 'idd':
            assert idd_yt_path
            app = IDDTrace(idd_yt_path, date, yql_token, yt_root)
            report = app.report()
            print ('==DTracing for IDD (%s)' % (date))
            lines = report.as_html()
            if output:
                with open(output, 'wb') as f:
                    f.write(lines.encode('utf-8'))
            else:
                print (lines)
        else:
            raise DTraceException("Unknown command")
    else:
        raise DTraceException("Command not found")
