#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import os
from datetime import date, timedelta

import yt.wrapper as yt

from disk.admin.monitors.common.juggler import send_juggler, ok, warn

PROCESSED_STIDS_COUNT_THRESHOLD = 50000000


def get_processed_stids_status():
    yt.config['token'] = os.getenv("DISK_STAT_TOKEN")
    yt.config.set_proxy('hahn.yt.yandex.net')

    yesterday_date = date.today() - timedelta(days=1)
    date_str = yesterday_date.strftime('%Y-%m-%d')
    try:
        processed_stids_count = yt.row_count('//statbox/disk-mulca-clean-log/' + date_str)
    except yt.errors.YtHttpResponseError:
        return warn('No data for the number of processed stids by clean')

    if processed_stids_count < PROCESSED_STIDS_COUNT_THRESHOLD:
        return warn('The number of processed stids by clean is too low')
    return ok('OK')


def main():
    status, text = get_processed_stids_status()
    send_juggler('disk_mworker_devops', 'processed_stids_count_host', status, text)
