# -*- coding: utf-8 -*-

import os
import sys


dir_path = '/'.join(os.path.abspath(__file__).split('/')[:-2])
sys.path = [dir_path] + sys.path

try:
    from disk.admin.monitors.common.staff import YandexStaffClient  # noqa
except ImportError:
    from common.staff import YandexStaffClient  # noqa


staff_client = YandexStaffClient(os.getenv('STAFF_TOKEN'))

mpfs_followers = staff_client.get_users_by_groups([
    'yandex_personal_cloud_dev_platform_core',
])

java_followers = staff_client.get_users_by_groups([
    'yandex_personal_cloud_dev_java',
])

frontend_followers = {
    'chestnov',
    'km256',
    'kri0-gen',
    'turbokuzmich',
    'yanann11',
    'dmi3rm',
}

FOLLOWERS = {
    'mpfs-access-log': mpfs_followers,
    'djfs-access-log': mpfs_followers,
    'ydisk-downloader-access-log': java_followers,
    'ydisk-nginx-access-docfront-log': frontend_followers,
    'ydisk-nginx-access-log': frontend_followers,
    'ydisk-nginx-access-log-api': mpfs_followers,
    'ydisk-nginx-access-log-dataapi': java_followers,
    'ydisk-nginx-access-log-uploader': java_followers,
    'ydisk-nginx-access-log-previewer': java_followers,
    'ydisk-nginx-access-log-zipper': java_followers,
    'ydisk-nginx-access-log-videostreaming': java_followers,
    'ydisk-java-webdav-access-log': java_followers,
    'ydisk-nginx-access-log-urlshortener': java_followers,
    'ydisk-nginx-access-public-log': frontend_followers,
}
