import re
from collections import defaultdict

URI_PATTERNS = defaultdict(lambda: re.compile(r"^(/[^?]*?)(/\d|\?|/\.|$)"))


_custom_patterns = {
    'ydisk-nginx-access-log-api': re.compile(
        r"^("
        r"/v1/data/app/databases|"
        r"/v1/disk/photoslice|"
        r"/v1/disk/operations|"
        r"/v1/commentaries|"
        r"/v1/personality/profile/persdata|"
        r"/v1/disk/public/resources|"
        r"/v1/data/subscriptions/|"
        r"/v1/disk/notifications/subscriptions/|"
        r"/v1/notes/notes|"
        r"/v1/personality/profile|"
        r"/v1/case/[^/]+/[^/]+|"
        r"/v1/disk/wopi"
        r")"
    ),
    'ydisk-nginx-access-log-comments': re.compile(
        r"^("
        r"/v1/?[^/]*?|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-nginx-access-log-dataapi': re.compile(
        r"^("
        r"/api/databases|"
        r"/profile/events/|"
        r"/(platform|v1)/personality/profile/[^/]*/([^/]*/)?|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-downloader-access-log': re.compile(
        r"^("
        r"/disk|"
        r"/preview|"
        r"/share|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-java-webdav-access-log': re.compile(
        r"^("
        r"/disk|"
        r"/photostream|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-nginx-access-log-uploader': re.compile(
        r"^("
        r"/preview|"
        r"/disk|"
        r"/share|"
        r"/v1/disk/wopi|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-nginx-access-public-log': re.compile(
        r"^("
        r".*?/(d|i|a)/|"
        r"/public3/direct|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-nginx-access-log': re.compile(
        r"^("
        r".*?/(d|i|a)/|"
        r"/(client|edit)/[^/]*/?|"
        r"/public3/direct|"
        r"/public/|"
        r"/upload/|"
        r"/[^?]*?(?=/\d|\?|/\.|$)"
        r")"
    ),
    'ydisk-nginx-access-log-videostreaming': re.compile(r"^(/[^/\?]*)"),
    'ydisk-nginx-access-docfront-log': re.compile(r"^(/).*"),
    'ydisk-nginx-access-log-urlshortener': re.compile(r"^(/).*"),
}
_custom_patterns['ydisk-nginx-access-log-previewer'] = _custom_patterns['ydisk-nginx-access-log-uploader']
_custom_patterns['ydisk-nginx-access-log-zipper'] = _custom_patterns['ydisk-nginx-access-log-uploader']

URI_PATTERNS.update(_custom_patterns)
