#!/usr/bin/python
# -*- coding: utf-8 -*-

from jinja2 import Template
import json


def format_mail(errors, template="mail.jinja2"):
    try:
        template = Template(unicode(open(template).read(), "utf-8"))
    except Exception as e:
        template = Template(unicode(open("product_monitor/" + template).read(), "utf-8"))

    return template.render(errors=errors)


if __name__ == '__main__':
    errors = [
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"Android: уведомления",
            "graph_name": u"Воспоминания: показы",
            "current_value": 63000.12312415,
            "prev_value": 66000,
            "delta": 3000.12312415,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotifications"
        },
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"Android: уведомления",
            "graph_name": u"Воспоминания: клики",
            "current_value": 63000,
            "prev_value": 66000,
            "delta": 3000,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotifications"
        },
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"iOS: уведомления об автозагрузке",
            "graph_name": u"Автозагрузка: клики",
            "current_value": 63000,
            "prev_value": 66000,
            "delta": 3000,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotificationsiOS"
        }
    ]
    errors = json.load(open('erros.json'))
    print format_mail(errors).encode("UTF-8")

    errors = [e for e in errors if e["tab_name"] == u"Аудитория"]
    print format_mail(errors).encode("UTF-8")
