#!/usr/bin/python
# -*- coding: utf-8 -*-

from os import getenv
from datetime import date, timedelta, datetime

import smtplib
import json
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

from format_mail import format_mail


TO = ["akinfold@yandex-team.ru", "zanzara@yandex-team.ru", "aslonovskiy@yandex-team.ru"]
SUBJECT_PREFIX = "Мониторинг продуктовых показателей"


def send_mail(html, to=TO, subject_prefix=SUBJECT_PREFIX):
    s = smtplib.SMTP_SSL('smtp.yandex-team.ru')
    s.login('robot-disk-p-monitor', getenv('ROBOT_PASSWORD'))

    for t in to:
        msg = MIMEMultipart('alternative')
        msg['Subject'] = subject_prefix + " " + (datetime.now() - timedelta(days=1)).strftime('%Y-%m-%d %H:%M')
        msg['From'] = "robot-disk-p-monitor@yandex-team.ru"
        msg['To'] = t

        part_html = MIMEText(html, 'html')
        msg.attach(part_html)

        s.sendmail(msg['From'], msg['To'], msg.as_string())

    s.quit()


if __name__ == '__main__':
    errors = [
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"Android: уведомления",
            "graph_name": u"Воспоминания: показы",
            "current_value": 63000.12312415,
            "prev_value": 66000,
            "delta": 3000.12312415,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotifications"
        },
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"Android: уведомления",
            "graph_name": u"Воспоминания: клики",
            "current_value": 63000,
            "prev_value": 66000,
            "delta": 3000,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotifications"
        },
        {
            "date_str": "2018-03-21",
            "tab_name": u"Уведомления",
            "widget_name": u"iOS: уведомления об автозагрузке",
            "graph_name": u"Автозагрузка: клики",
            "current_value": 63000,
            "prev_value": 66000,
            "delta": 3000,
            "avg_delta": 12,
            "std_dev": 900,
            "href": "https://charts.yandex-team.ru/preview/wizard/ivan-m/DiskAndroidNotificationsiOS"
        }
    ]
    errors = json.load(open('erros.json'))
    send_mail(format_mail(errors).encode("UTF-8"), to=["tolmalev@yandex-team.ru"])

    errors = [e for e in errors if e["tab_name"] == u"Аудитория"]
    send_mail(format_mail(errors).encode("UTF-8"), to=["tolmalev@yandex-team.ru"], subject_prefix="Аудитория")
