# -*- coding: utf-8 -*-
import json
import logging
import requests
import time
from datetime import datetime, timedelta
from dateutil.parser import parse
from os import getenv

from common.abc import YandexAbcClient
from common.startrek import StartrekClient

logging.basicConfig()
requests.packages.urllib3.disable_warnings()

start_time = datetime.now()

current_date = start_time.strftime('%d-%m-%Y')
current_date_format = start_time.strftime('%Y-%m-%d')

startrek_client = StartrekClient()
abc_client = YandexAbcClient(getenv('ABC_TOKEN'))

for param in [{'robot_name': 'robot-disk-java-mntr', 'schedule_id': 2578, 'queue': 'DISKBACKMON'}]:
    print "Handle robot ", param

    robot = param['robot_name']
    schedule_id = param['schedule_id']
    queue = param['queue']

    escalations = requests.post(
        url='https://juggler.yandex-team.ru/api2/escalations/get_escalations_log',
        json={
            'filters': [
                {'recipients': [robot]}
            ],
            'page_size': 100,
        },
        verify=False,
    ).json()['escalations']

    print "Get ecalations"
    print json.dumps(escalations, indent=4)

    duty_list = abc_client.get_shifts(schedule_id, current_date_format, current_date_format)
    print "Duties today {}".format(duty_list)

    for escalation in escalations:
        print "Handle escalation {}".format(escalation['escalation_id'])
        call_duty = False
        for log_item in escalation['log']:
            if log_item['simple_login'] == robot:
                call_duty = True
                break

        if call_duty:
            print "Escalation call duty robot"
        else:
            print "Escalation not call duty robot"
            continue

        if escalation['service'] == 'check_ytLogJobs':
            notifications = requests.post(
                url='https://juggler.yandex-team.ru/api2/history/get_notifications',
                json={
                    'filters': [
                        {'login': robot, 'service': escalation['service'], 'host': escalation['host']},
                    ],
                    'page_size': 100,
                    'page': 1,
                    'since': (datetime.now() - timedelta(days=1)).strftime('%s'),
                    'until': datetime.now().strftime('%s'),
                },
                verify=False,
            ).json()['notifications']
            subalerts = notifications[0]['description'].split('\n')[1:]
            alerts = ['{}:{}:{}'.format(escalation['host'], escalation['service'], x.split('.')[0]) for x in subalerts]
        else:
            alerts = ['{}:{}'.format(escalation['host'], escalation['service'])]
        print "Escalation alerts {}".format(alerts)

        for alert in alerts:
            exists_issues = filter(lambda i: robot in i['tags'], startrek_client.get_issues({'queue': queue, 'tags': [alert], 'releaseComment': escalation['escalation_id']}))
            if len(exists_issues) > 0:
                print "Found exists issue {}".format(exists_issues)
                continue

            open_issues = filter(lambda i: robot in i['tags'], startrek_client.get_issues({'queue': queue, 'resolution': 'empty()', 'tags': [alert]}))
            print "Found open issues {}".format(open_issues)

            escalation_time=escalation['start_time']
            if escalation.get('stopped') is not None and 'time' in escalation['stopped']:
                escalation_time=escalation['stopped']['time']

            iso_to_ts = lambda iso_dt_string: time.mktime(parse(iso_dt_string).timetuple())
            duty_for_alert = [duty for duty in duty_list if iso_to_ts(duty['start_datetime']) <= escalation_time < iso_to_ts(duty['end_datetime'])]
            print "Found duty on alert {}".format(duty_for_alert)
            duty_login_list = list(map(lambda duty: duty['person']['login'], duty_for_alert))

            if len(open_issues) > 0:
                print "Issue in {} status".format(open_issues[0].status.key)
                open_issue = open_issues[0]
                open_issue.comments.create(
                    text=u'Повторно позвонили по алерту {}\n<{{System info\n%%{}%%}}>'.format(alert, json.dumps(escalation, indent=4)),
                    summonees=duty_login_list
                )
                open_issue.update(releaseComment='{}\n{}'.format(open_issue.releaseComment, escalation['escalation_id']), ignore_version_change=True)
                if open_issue.status.key == 'needImprovement':
                    open_issue.transitions['neo'].execute()
            else:
                print "Create new issue"

                prev_issues = filter(lambda i: robot in i['tags'], startrek_client.get_issues({'tags': alert}, orderBy='updated', orderAsc=False))
                print "Find prev issues {}".format(prev_issues)
                if len(prev_issues) > 0:
                    prev_issues_text = 'Прошлые тикеты по алерту:\n{}\n\n'.format(
                        '\n'.join([x.key for x in prev_issues[:5]])
                    )
                else:
                    prev_issues_text = ""

                juggler_link = "https://juggler.yandex-team.ru/check_details/?host={}&service={}&last=1DAY".format(
                    escalation['host'],
                    escalation['service']
                )
                description = """(({} Алерт в джаглере))\n\n{}""".format(juggler_link, prev_issues_text)

                created_issue = startrek_client.create_issue(
                    queue=queue,
                    type={'name': u'Задача'},
                    summary='Алерт {} ({})'.format(alert, current_date),
                    description=description,
                    releaseComment=escalation['escalation_id'],
                    tags=[robot, alert]
                )

                created_issue.comments.create(
                    text=u'Позвонили по алерту {}\n<{{System info\n%%{}%%}}>'.format(alert, json.dumps(escalation, indent=4)),
                    summonees=duty_login_list
                )

                print "Created new issue " + created_issue.key
