#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

import logging
from os import getenv
from common.tasks_count_checker import TasksCountChecker
from common.juggler import ok, warn, crit

logging.basicConfig(level=logging.INFO)

JUGGLER_SETUP = {
    'OK': (ok, logging.info),
    'WARN': (warn, logging.info),
    'CRIT': (crit, logging.critical)
}

def log_and_return(level, num, min, max):
    if num < min or num > max:
        text = "is NOT between"
    else:
        text = "is between"
    j, l = JUGGLER_SETUP[level]
    l(level + ": %d %s %d and %d" % (num, text, min, max))
    return j("`{}` {} `{}` and `{}`".format(num, text, min, max))

class TaskChecker(TasksCountChecker):
    def __init__(self):
        super(TaskChecker, self).__init__(
            getenv("BAZINGA_TASK"),
            getenv("JUGGLER_HOST"),
            getenv("JUGGLER_SERVICE")
        )

    def check(self, tasks_num):
        if len(self.thresholds) < 4:
            logging.critical("You need to pass env THRESHOLDS")
            return warn("Misconfigured script")

        if tasks_num < self.thresholds[0] or tasks_num > self.thresholds[3]:
            return log_and_return('CRIT', tasks_num, self.thresholds[0], self.thresholds[3])
        elif tasks_num < self.thresholds[1] or tasks_num > self.thresholds[2]:
            return log_and_return('WARN', tasks_num, self.thresholds[1], self.thresholds[2])
        else:
            return log_and_return('OK', tasks_num, self.thresholds[1], self.thresholds[2])

if __name__ == '__main__':
    checker = TaskChecker()
    checker.get_count_check_and_send()
