#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import logging
import sys
from os import path as os_path
import tempfile

dir_path = '/'.join(os_path.abspath(__file__).split('/')[:-2])
sys.path = [dir_path] + sys.path

from common.calendar import YandexCalendarClient
from common.startrek import StartrekTicket


TICKET_SUBJECT = u"java: Разобрать долгие запросы и 500-ки из %s"
TICKET_QUEUE = 'CHEMODAN'
TICKET_COMPONENTS = [
    u'java дежурный',
]
TICKET_TAGS = [
    "IDD",
    u"разбор_idd",
]
TICKET_FOLLOWERS = [
    "akinfold",
]

TICKET_DESCRIPTION = u"""
**Таск:** https://st.yandex-team.ru/%(idd_ticket)s

**Таблицы:**
* access-log_5xx: %(yt_prefix)s%(errors_url)s
* java логи приложений по ycrid из 5xx : %(yt_prefix)s%(java_log_from_errors)s
* access-log_долгие: %(yt_prefix)s%(long_url)s
* java логи приложений по ycrid из долгих запросов : %(yt_prefix)s%(java_log_from_long)s
* access-log_долгие из mpfs: %(yt_prefix)s%(long_from_mpfs_url)s
* java логи приложений по ycrid из долгих запросов из mpfs : %(yt_prefix)s%(java_log_from_long_mpfs)s
* nginx логи по всем ycrid из предыдущих: %(yt_prefix)s%(nginx_all_logs)s

**Инструкция:**
Каждая проблема должна быть связана с одним из тасков отсюда: https://wiki.yandex-team.ru/disk/java/improvements/
Если соответствующего таска нет - его надо завести
* Для sync-dataapi лимит на разбор по таймингам 4с вместо 2с
* /v1/data из мпфс-лога - разбираем
* /v1/commentaries из мпфс-лога - разбираем
* /v1/disk/photoslice из мпфс-лога - разбираем
* /v1/notes из мпфс-лога - разбираем
* Запросы upload-target - не разбираем
* Если в nginx-логе на нашей стороне запроса нет или он быстрый,
  а в мпфс-логе запрос долгий - линковать к таску про таймауты в сети (есть на вики-странице)
"""


def create_java_investigation_ticket(idd_ticket_key, calendar_private_token, day, description_params):
    yandex_calendar_client = YandexCalendarClient(calendar_private_token)
    event_duty, _ = yandex_calendar_client.get_current_event()
    dtrace_report = description_params.pop('dtrace_report', None)
    if not event_duty:
        return None
    java_duty = event_duty.rsplit()[-1].strip('@')
    try:
        ticket = StartrekTicket(
            TICKET_SUBJECT % idd_ticket_key,
            assignee=java_duty,
            followers=TICKET_FOLLOWERS,
            queue=TICKET_QUEUE)

        description = TICKET_DESCRIPTION % dict(idd_ticket=idd_ticket_key, **description_params)

        ticket_args = dict(
            description=description,
        )

        if dtrace_report:
            report_filename = '%s-java.html' % idd_ticket_key
            with open(report_filename, 'wb') as fp:
                fp.write(dtrace_report.encode('utf-8'))
            ticket_args['attachments'] = [report_filename]

        if ticket.is_can_be_created():
            ticket_args.update(dict(
                components=TICKET_COMPONENTS,
                tags=TICKET_TAGS,
                do_not_comment=True,
            ))
            ticket_key = ticket.create(**ticket_args)
            return ticket_key
        else:
            issue = ticket.issues[0]
            issue.update(**ticket_args)
            return issue.key
    except Exception:
        logging.exception("Can't create java investigation ticket")
