#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import logging
import sys
from os import path as os_path

dir_path = '/'.join(os_path.abspath(__file__).split('/')[:-2])
sys.path = [dir_path] + sys.path


from common.calendar import YandexCalendarClient
from common.startrek import StartrekTicket


TICKET_SUBJECT = u"%(mob_platform)s: Разобрать %(investigation_type)s из %(idd_ticket)s за %(day)s"
TICKET_QUEUE = 'MOBDISK'
TICKET_COMPONENTS = {
    'android': ['YD Android'],
    'ios': ['YD iOS'],
}

TICKET_TAGS = [
    "IDD",
    "duty",
]
TICKET_VERSION = {
    'ios': 'iOS / IDD',
}
TICKET_FOLLOWERS = {
    'android': ['feelgood'],
    'ios': ['asinusov'],
}
TICKET_DESCRIPTION = u"""
Таск: https://st.yandex-team.ru/%(idd_ticket)s

* Таблица с данными: %(yt_prefix)s%(table_url)s
"""


def create_mobile_investigation_ticket(mob_platform, investigation_type, idd_ticket,
                                       calendar_private_token, day, description_params):
    yandex_calendar_client = YandexCalendarClient(calendar_private_token)
    event_duty, _ = yandex_calendar_client.get_current_event()
    current_duty = None
    if event_duty:
        current_duty = event_duty.rsplit()[-1].strip('@')

    try:
        ticket = StartrekTicket(
            TICKET_SUBJECT % dict(
                mob_platform=mob_platform,
                investigation_type=investigation_type,
                idd_ticket=idd_ticket,
                day=day,
            ),
            assignee=current_duty,
            followers=TICKET_FOLLOWERS[mob_platform],
            queue=TICKET_QUEUE,
            unique='%s mob investigation %s' % (idd_ticket, mob_platform))

        return ticket.create(
            description=TICKET_DESCRIPTION % dict(idd_ticket=idd_ticket, **description_params),
            components=TICKET_COMPONENTS[mob_platform],
            tags=TICKET_TAGS,
            do_not_comment=True,
            fix_version=TICKET_VERSION.get(mob_platform),
        )
    except Exception:
        logging.exception("Can't create %s investigation ticket" % mob_platform)
