#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
import logging
import sys
from os import path as os_path
from StringIO import StringIO
from datetime import datetime
import tempfile

dir_path = '/'.join(os_path.abspath(__file__).split('/')[:-2])
sys.path = [dir_path] + sys.path

from common.calendar import YandexCalendarClient
from common.startrek import StartrekTicket
from fast_idd import process_errors, process_slow, format_st_table

TICKET_SUBJECT = u"mpfs: Разобрать долгие запросы и 500-ки из %s за %s"
TICKET_QUEUE = 'CHEMODAN'
TICKET_COMPONENTS = [
    u'mpfs',
]
TICKET_TAGS = [
    "IDD",
    u"разбор_idd",
    "mpfs-idd",
]
TICKET_FOLLOWERS = [
    "akinfold",
    "waser",
]
TICKET_DESCRIPTION = u"""
Таск: https://st.yandex-team.ru/%(idd_ticket)s

* access-log_5xx: %(yt_prefix)s%(errors_url)s
* access-log_долгие: %(yt_prefix)s%(timings_url)s
* Join по ycrid + request_id запросов access-log_5xx с error-log: %(yt_prefix)s%(joined_errors_url)s
* Join по ycrid + request_id запросов access-log_долгие с requests-log. %(yt_prefix)s%(joined_timings_url)s
* Самый долгий запрос по requests-log по ycrid+request_id: %(yt_prefix)s%(max_request_url)s
* nginx логи по всем ycrid из предыдущих: %(yt_prefix)s%(nginx_all_logs)s
* Логи envoy по ycrid из долгих запросов: %(yt_prefix)s%(mpfs_envoy_requests)s
"""


def create_mpfs_investigation_ticket(idd_ticket, calendar_private_token, day, description_params):
    yandex_calendar_client = YandexCalendarClient(calendar_private_token)
    event_duty, _ = yandex_calendar_client.get_current_event()
    dtrace_report = description_params.pop('dtrace_report', None)
    if not event_duty:
        return None
    current_duty = event_duty.rsplit()[-1].strip('@')
    try:
        ticket = StartrekTicket(
            TICKET_SUBJECT % (idd_ticket, day),
            assignee=current_duty,
            followers=TICKET_FOLLOWERS,
            queue=TICKET_QUEUE)

        description = TICKET_DESCRIPTION % dict(
            idd_ticket=idd_ticket,
            **description_params
        )

        ticket_args = dict(
            description=description,
        )

        if dtrace_report:
            report_filename = '%s-mpfs.html' % idd_ticket
            with open(report_filename, 'wb') as fp:
                fp.write(dtrace_report.encode('utf-8'))
            ticket_args['attachments'] = [report_filename]

        if ticket.is_can_be_created():
            ticket_args.update(dict(
                components=TICKET_COMPONENTS,
                tags=TICKET_TAGS,
                do_not_comment=True,
            ))
            ticket_key = ticket.create(**ticket_args)
            return ticket_key
        else:
            issue = ticket.issues[0]
            issue.update(**ticket_args)
            return issue.key
    except Exception:
        logging.exception("Can't create mpfs investigation ticket")


def mpfs_fast_idd(idd_ticket, day):
    dt = datetime.strptime(day, '%Y-%m-%d')
    # it's useless to rework original @waser script with print
    # so redirect stdout to buffer
    f = StringIO()
    original = sys.stdout
    sys.stdout = f
    error = process_errors(dt)
    error.sort()
    slow = process_slow(dt)
    slow.sort()
    print '==== IDD Result'
    format_st_table('Error %s' % dt, error)
    format_st_table('Slow %s' % dt, slow)
    sys.stdout.flush()
    comment = sys.stdout.getvalue()
    sys.stdout = original

    try:
        ticket = StartrekTicket(
            TICKET_SUBJECT % (idd_ticket, day),
            queue=TICKET_QUEUE)
        issue = ticket.issues[0]
        for comment in issue.comments.get_all():
            if comment.createdBy.login == 'robot-disk-duty-adm':
                comment.update(text=comment)
                return issue.key
        issue.comments.create(text=comment)
        return issue.key
    except Exception:
        logging.exception("Can't add fast idd comment to mpfs investigation ticket")
