#!/bin/bash

getent group nginx >/dev/null 2>&1 || groupadd -g 58 nginx >/dev/null 2>&1
getent passwd nginx >/dev/null 2>&1 || useradd -s /bin/bash -m -g nginx -u 58 nginx >/dev/null 2>&1

mkdir -p /var/log/mpfs /var/run/mpfs /var/lib/mpfs
chown -R nginx:nginx /var/log/mpfs /var/run/mpfs /var/lib/mpfs

for package in python-mpfs-disk python-mpfs-queue python-mpfs-api rabbitmq-server; do
	/var/lib/dpkg/info/${package}.postinst configure
done

sed -i 's#^script$#script\
    export QLOUD_DATACENTER=`grep datacenter /etc/qloud/meta.yaml | awk "{print \\$NF}"`\n#' \
    	/etc/init/mpfs-core-uwsgi-disk.conf \
        /etc/init/mpfs-intapi-uwsgi.conf \
        /etc/init/mpfs-extapi-uwsgi.conf \
		/etc/init/mpfs-queue2-worker.conf

update-rc.d nginx enable
update-rc.d rabbitmq-server defaults
update-rc.d rabbitmq-server enable

service rabbitmq-server start

rabbitmqctl add_vhost disk_test_queller; rabbitmqctl add_user mpfs_test mpfs_test; rabbitmqctl set_permissions -p disk_test_queller mpfs_test  ".*" ".*" ".*"

/root/restart_all.sh

# starts 2 PG with mpfs migrations on ports 12000 and 12001
python /root/pg_helper.py 12000 2
