# coding=utf-8
import requests


class API(object):
    """Базовый класс для работы с API"""

    def __init__(self, url, headers=None, json=True):
        self.url = url
        self.headers = {}

        if json:
            self.headers['accept'] = 'application/json; charset=utf-8'
        if headers:
            self.headers.update(headers)

    def _request(self, url, method='GET', params=None, json_data=None, base_url=None, raw=False, headers=None):
        headers = dict(self.headers, **headers if headers else {})
        if base_url is None:
            base_url = self.url
        if json_data:
            response = requests.request(method, base_url + url, json=json_data, headers=headers)
        elif params:
            response = requests.request(method, base_url + url, params=params, headers=headers)
        else:
            response = requests.request(method, base_url + url, headers=headers)

        if response.status_code != 200:
            raise Exception("%s %s" % (response.status_code, response.content))

        if raw:
            return response.text

        return response.json()
