# -*- coding: utf-8 -*-
import click

from qloud_deploy import __version__
from qloud_deploy.deploy.cli import deploy
from qloud_deploy.docker.cli import docker
from qloud_deploy.infra.cli import infra
from qloud_deploy.juggler.cli import juggler
from qloud_deploy.mpfs.cli import mpfs
from qloud_deploy.qloud.cli import qloud
from qloud_deploy.sandbox.cli import sandbox


@click.group(help=u'Yandex.Disk qloud and deploy tool')
@click.version_option(version=__version__)
def main():
    pass


main.add_command(deploy)
main.add_command(docker)
main.add_command(infra)
main.add_command(juggler)
main.add_command(mpfs)
main.add_command(qloud)
main.add_command(sandbox)


if __name__ == '__main__':
    main()
