# -*- coding: utf-8 -*-
import yp.data_model as data_model
import yt.yson as yson
import yt_yson_bindings

from infra.dctl.src import consts as dctl_consts
from infra.dctl.src.cmd.dctl_cli import DctlContext
from qloud_deploy.juggler import Juggler
from qloud_deploy.utils import print_warn


class Deploy(object):
    """
    Базовый класс работы с Deploy API
    """
    def __init__(self, auth_token):
        self.url = "https://deploy.yandex-team.ru/stage"
        self.ctx = DctlContext(
            dctl_token_path='',
            yp_urls={c.name.lower(): c.address for c in dctl_consts.CLUSTER_CONFIGS.values()},
            vault_host=dctl_consts.VAULT_HOST,
        )
        self.client = self.ctx.get_client(dctl_consts.XDC_PRODUCTION_CLUSTER)

    def get_stage(self, stage_id):
        return self.client.get_dict(object_type=data_model.OT_STAGE, object_id=stage_id)

    def put(self, stage_dict):
        stage = yt_yson_bindings.loads_proto(
            yson.dumps(stage_dict), proto_class=data_model.TStage, skip_unknown_fields=False
        )
        self.client.update_stage(object_type=data_model.OT_STAGE, object_id=stage.meta.id, obj=stage)
        return True

    def get_url(self, stage_id):
        return "%s/%s" % (self.url, stage_id)

    @staticmethod
    def set_downtime(stage_id, seconds, comment, juggler_token, dt_services=()):
        if not juggler_token:
            print_warn("Juggler OAuth token not set. SKIP downtime")
            return

        dt_services = dt_services or ['service-locker', 'service-status']

        filters = [
            {
                'host': stage_id,
                'service': service,
            }
            for service in dt_services
        ]
        Juggler(juggler_token).set_downtimes(
            filters,
            seconds=seconds,
            description=comment,
        )
