# -*- coding: utf-8 -*-
import copy

from qloud_deploy.sandbox import Sandbox
from qloud_deploy.utils import (auto_split_dict, generate_comment,
                                parse_dict_params)


def deploy_unit_update(registry, deploy_unit_key, deploy_unit_info, image_kwargs, **kwargs):
    box_image_kwarg = image_kwargs[deploy_unit_key]
    if box_image_kwarg:
        for box in deploy_unit_info['images_for_boxes']:
            image_info = deploy_unit_info['images_for_boxes'][box]
            if box_image_kwarg == "latest":
                box_image_kwarg = registry.get_latest_tag(image_info['name'])

            if ':' in box_image_kwarg:
                box_image_kwarg = box_image_kwarg.split(':')[-1]
            deploy_unit_info['images_for_boxes'][box]['tag'] = box_image_kwarg

    if kwargs.get('sandbox'):
        sandbox_resources = parse_dict_params(kwargs['sandbox'], sep=':')
        try:
            resources = deploy_unit_info['multi_cluster_replica_set']['replica_set'][
                'pod_template_spec']['spec']['pod_agent_payload']['spec']['resources']['static_resources']
        except KeyError:
            resources = deploy_unit_info['replica_set']['replica_set_template'][
                'pod_template_spec']['spec']['pod_agent_payload']['spec']['resources']['static_resources']
        for resource in resources:
            if resource['id'] in sandbox_resources:
                sandbox_resource = Sandbox().get_resource_by_key(sandbox_resources[resource['id']])
                resource['url'] = sandbox_resource['skynet_id']
                resource['verification']['checksum'] = 'MD5:%s' % sandbox_resource['md5']

    return deploy_unit_info


def get_comment(stage):
    return stage['spec']['revision_info']['description']


def stage_update(registry, current_stage, **kwargs):
    stage = copy.deepcopy(current_stage)
    stage['spec']['revision_info']['description'] = kwargs['comment'] or generate_comment(kwargs)
    image_kwargs = auto_split_dict(kwargs, 'image')
    for deploy_unit_key, deploy_unit_info in stage['spec']['deploy_units'].items():
        stage['spec']['deploy_units'][deploy_unit_key] = deploy_unit_update(
            registry, deploy_unit_key, deploy_unit_info, image_kwargs, **kwargs
        )

    return stage
