# -*- coding: utf-8 -*-

from qloud_deploy.api import API


class Infra(API):
    """Базовый класс для работы с Infra API"""
    service_ids = {
        'disk': 446,
        'dataapi': 405,
    }

    environment_ids = {
        'disk': {
            'testing': 1644,
            'stable': 704,
        },
        'dataapi': {
            'stable': 638,
        },
    }

    def __init__(self, token):
        self.event_url = 'https://infra.yandex-team.ru/event'
        super(Infra, self).__init__(
            'https://infra-api.yandex-team.ru/v1/events',
            {'Authorization': 'OAuth %s' % token},
        )

    def create_event(self, event):
        """Создать событие в Infra"""
        return self._request('', method='POST', json_data=event)
