# -*- coding: utf-8 -*-
import time

from qloud_deploy.api import API


class Juggler(API):
    """Базовый класс для работы с Juggler API"""

    def __init__(self, token):
        super(Juggler, self).__init__(
            "http://juggler-api.search.yandex.net/v2/",
            {'Authorization': 'OAuth %s' % token},
        )

    def set_downtimes(self, filters, seconds=1800, description="Disk qloud deploy"):
        """Поставить даунтайм с фильтрами"""
        params = {
            'filters': filters,
            'end_time': time.time() + seconds,
            'description': description,
            'source': 'qloud-deploy',
        }
        answer = self._request('downtimes/set_downtimes', method='POST', json_data=params)
        if 'downtime_id' in answer:
            return 'https://juggler.yandex-team.ru/downtimes/?query=downtime_id=' + answer['downtime_id']
        return None
