import click

from qloud_deploy.juggler import Juggler
from qloud_deploy.utils import pprint


@click.group('juggler', help=u"Juggler manipulation")
def juggler():
    pass


@click.command(help=u"Set downtime")
@click.option('--host', help='Host')
@click.option('--service', help='Service')
@click.option('--seconds', default=1800, help='End time')
@click.option('--description', help='Description')
@click.option('--juggler-token', help='Juggler OAuth token', envvar='JUGGLER_OAUTH_TOKEN', required=True)
def downtime(host, service, seconds, description, juggler_token):
    juggler_api = Juggler(juggler_token)
    one_filter = {}
    if host:
        one_filter['host'] = host
    if service:
        one_filter['service'] = service
    pprint(juggler_api.set_downtimes([one_filter], seconds, description))


juggler.add_command(downtime)
