# -*- coding: utf-8 -*-
import copy

from qloud_deploy.utils import auto_split_dict, generate_comment, parse_dict_params, print_error


def component_update(qloud, registry, component, environment_id, image_kwargs, strict=False, **kwargs):
    if kwargs.get('size'):
        component['properties']['size'] = kwargs['size']
    if kwargs.get('disk_size'):
        component['properties']['diskSize'] = kwargs['disk_size']
    if kwargs.get('network'):
        component['properties']['network'] = kwargs['network']
    component_image_kwarg = image_kwargs[component['componentName']]
    if component_image_kwarg:
        if component_image_kwarg == "latest":
            image_url = qloud.get_images(environment_id).get(component['componentName'], '')
            repository, image_hash = registry.get_latest(image_url)
        else:
            repository = component_image_kwarg
            image_hash = registry.get_hash(repository)
        if repository:
            component['repository'] = component['properties']['repository'] = repository
            component['hash'] = component['properties']['hash'] = image_hash
    if kwargs.get('application'):
        component['sandboxResources'] = qloud.update_sandbox(
            'application', kwargs['application'], component['sandboxResources'], strict)
    if kwargs.get('mpfs'):
        component['sandboxResources'] = qloud.update_sandbox(
            'mpfs', kwargs['mpfs'], component['sandboxResources'], strict)
    if kwargs.get('settings'):
        component['sandboxResources'] = qloud.update_sandbox(
            'settings', kwargs['settings'], component['sandboxResources'], strict)
    if kwargs.get('stop_hook'):
        component['stopAction'] = qloud.http_stop_action()
    if kwargs.get('service_status_hook'):
        component['statusHookChecks'] = qloud.update_status_hooks(
            qloud.http_service_status_action(),
            component['statusHookChecks']
        )
    if kwargs.get('status_hook'):
        args = kwargs['status_hook'].split(':')
        if len(args) > 2:
            hook = qloud.http_status_hook(path=args[1], port=int(args[0]), timeout=int(args[2]))
        elif len(args) > 1:
            hook = qloud.http_status_hook(path=args[1], port=int(args[0]))
        else:
            hook = qloud.http_status_hook(port=int(args[0]))
        component['statusHookChecks'] = qloud.update_status_hooks(hook, component['statusHookChecks'])

    if kwargs.get('remove_status_hook_by_port'):
        for status_hook_port in kwargs.get('remove_status_hook_by_port'):
            status_hook_port = int(status_hook_port)
            component['statusHookChecks'] = qloud.remove_status_hook(
                component['statusHookChecks'],
                port=status_hook_port,
            )

    if kwargs.get('units'):
        locations = parse_dict_params(kwargs['units'], sep=':')
        for instance_group in component['instanceGroups']:
            instance_group['units'] = locations.get(instance_group['location'], instance_group['units'])

    if 'updatePeriod' in component['activateRecipe'] and component['activateRecipe']['updatePeriod'] == '0':
        component['activateRecipe']['updatePeriod'] = '10'

    if kwargs.get('unistat_port') or kwargs.get('unistat_path'):
        component['properties']['unistat'] = 'true'
        component['properties']['unistatPort'] = kwargs.get('unistat_port',
                                                            component['properties'].get('unistatPort', 80))
        component['properties']['unistatPath'] = kwargs.get('unistat_path',
                                                            component['properties'].get('unistatPath', '/unistat'))

    if kwargs.get('no_unistat'):
        component['properties']['unistat'] = 'false'

    if 'useTorrents' in component['properties']:
        component['properties']['useTorrents'] = 'true'

    if kwargs.get('secret'):
        for secret in kwargs['secret']:
            try:
                secret_name, secret_target = secret.split(':')
            except ValueError:
                print_error('Bad secret: %s' % secret)
            else:
                component['secrets'] = qloud.update_secrets(component['secrets'], secret_name, secret_target)

    return component


def environment_update(qloud, registry, current_environment, environment_id, strict=False, **kwargs):
    environment = copy.deepcopy(current_environment)
    environment['comment'] = kwargs['comment'] or generate_comment(kwargs)
    if kwargs.get('user_var'):
        new_vars = parse_dict_params(kwargs['user_var'])
        environment['userEnvironmentMap'].update(new_vars)
    image_kwargs = auto_split_dict(kwargs, 'image')

    for component in environment['components']:
        # Skip proxy and component-proxy as non-configurable
        if component.get('componentType') != 'standard':
            continue

        component_update(qloud, registry, component, environment_id, image_kwargs, strict, **kwargs)

    for route in environment['routeSettings']:
        if kwargs.get('molly'):
            route['molly'] = True

    return environment
