import click

from qloud_deploy.sandbox import Sandbox
from qloud_deploy.utils import pprint


@click.group('sandbox', help=u"Sandbox resources")
def sandbox():
    pass


@click.command(help=u"List resources")
@click.option('-p', '--package', help='Filter Sandbox resources by package')
@click.option('-l', '--limit', default=10, help='Limit listing')
def resources(package, limit):
    sandbox_api = Sandbox()
    if package:
        package_name, version = (package.split('=') + [''])[:2]
        resources_list = sandbox_api.get_package_resources(package_name, package_version=version, limit=limit)
    else:
        resources_list = sandbox_api.get_resources(limit=limit)
    pprint(sandbox_api.format_resources(resources_list))


sandbox.add_command(resources)
