import difflib
import json
import sys
from collections import defaultdict

import click

from qloud_deploy import __version__


def pprint(obj, noout=False):
    out = json.dumps(obj, sort_keys=True, indent=2)
    if not noout:
        click.echo(out)
    return out


def print_diff(old_dict, new_dict):
    old_dict_json = pprint(old_dict, noout=True)
    new_dict_json = pprint(new_dict, noout=True)
    diff = difflib.unified_diff(old_dict_json.splitlines(), new_dict_json.splitlines())
    click.secho("DIFF:", fg='red')
    click.echo("\n".join(diff))


def generate_comment(kwargs):
    args = ["qloud-deploy@%s" % __version__]
    for param, value in sorted(kwargs.items()):
        if value:
            args.append("%s=%s" % (param, json.dumps(value)))
    return " ".join(args)


def print_error(message):
    click.secho(message, fg='red')


def print_warn(message):
    click.secho(message, fg='yellow')


def panic(message):
    click.secho(message, fg='red')
    sys.exit(1)


def parse_dict_params(params, sep='='):
    return dict(i.split(sep, 1) for i in params)


def auto_split_dict(kwargs, key):
    value = defaultdict(lambda: '')
    if kwargs.get(key):
        if len(kwargs[key]) > 1 or '=' in kwargs[key][0]:
            value.update(parse_dict_params(kwargs[key]))
        else:
            value = defaultdict(lambda: kwargs[key][0])
    return value
