package main

import (
	"fmt"
	"os"
)

type BalancerFetcher interface {
	fetchReals(string) ([]string, error)
}

func printReals(balancerFetcher BalancerFetcher, serviceID string) {
	reals, err := balancerFetcher.fetchReals(serviceID)
	if err != nil {
		_, _ = fmt.Fprintln(os.Stderr, err.Error())
		return
	}
	for _, real := range reals {
		fmt.Println(real)
	}
}
