package main

import (
	"io/ioutil"
	"net/http"
	"strings"
	"time"
)

type Conductor struct {
	url string
}

type ConductorSpec struct {
	Hostname string
}

type ConductorInstance struct {
	Spec ConductorSpec
}

type ConductorAnswer struct {
	Instance []ConductorInstance
}

func NewConductor() Conductor {
	conductor := Conductor{}
	conductor.url = "https://c.yandex-team.ru/api/groups2hosts/"
	return conductor
}

func (conductor Conductor) fetchReals(serviceID string) ([]string, error) {
	var hostnames []string
	var httpClient = &http.Client{Timeout: 10 * time.Second}
	r, err := httpClient.Get(conductor.url + serviceID)
	if err != nil {
		return hostnames, err
	}
	defer func() {
		_ = r.Body.Close()
	}()
	body, err := ioutil.ReadAll(r.Body)
	if err != nil {
		return hostnames, err
	}
	hostnames = strings.Fields(string(body))
	return hostnames, nil
}
