package main

import (
	"bytes"
	"encoding/json"
	"net/http"
	"time"
)

type HQ struct {
	hosts []string
}

type HQSpec struct {
	Hostname string
}

type HQInstance struct {
	Spec HQSpec
}

type HQAnswer struct {
	Instance []HQInstance
}

func NewHQ() HQ {
	hq := HQ{}
	hq.hosts = []string{
		"hq.vla-swat.yandex-team.ru",
		"hq.sas-swat.yandex-team.ru",
		"hq.man-swat.yandex-team.ru",
	}
	return hq
}

func (hq HQ) fetchRealsFromOneHost(serviceID string, hqHost string) ([]string, error) {
	var hostnames []string
	data := []byte(`{"filter":{"serviceID": "` + serviceID + `"}}`)
	jsonData := bytes.NewReader(data)
	var httpClient = &http.Client{Timeout: 10 * time.Second}
	hqAnswer := new(HQAnswer)
	r, err := httpClient.Post("https://"+hqHost+"/rpc/instances/FindInstances/", "application/json", jsonData)
	if err != nil {
		return hostnames, err
	}
	defer func() {
		_ = r.Body.Close()
	}()

	err = json.NewDecoder(r.Body).Decode(hqAnswer)
	if err != nil {
		return hostnames, err
	}
	for _, instance := range hqAnswer.Instance {
		hostnames = append(hostnames, instance.Spec.Hostname)
	}
	return hostnames, nil
}

func (hq HQ) fetchReals(serviceID string) ([]string, error) {
	var hostnames []string

	for _, hqHost := range hq.hosts {
		if hostnamesFromHost, err := hq.fetchRealsFromOneHost(serviceID, hqHost); err == nil {
			hostnames = append(hostnames, hostnamesFromHost...)
		}
	}
	return hostnames, nil
}
