package main

import (
	"flag"
)

func main() {
	fetchType := flag.String("from", "", "System to fetch reals from")
	serviceID := flag.String("id", "", "ID of fetch object")
	flag.Parse()
	var service BalancerFetcher
	switch *fetchType {
	case "hq":
		service = NewHQ()
	case "conductor":
		service = NewConductor()
	case "sd":
		service = NewSD()
	}
	if service != nil {
		printReals(service, *serviceID)
	}
}

