package main

import (
	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver"
	"a.yandex-team.ru/infra/yp_service_discovery/golang/resolver/grpcresolver"
	"context"
)

type SD struct {
	resolver resolver.Resolver
	ctx      context.Context
}

func NewSD() SD {
	sd := SD{}
	r, err := grpcresolver.New()
	if err != nil {
		return sd
	}
	sd.resolver = r
	sd.ctx = context.Background()
	return sd
}

func (sd SD) fetchRealsFromOneCluster(serviceID string, cluster string) ([]string, error) {
	var hostnames []string
	resp, err := sd.resolver.ResolveEndpoints(sd.ctx, cluster, serviceID)
	if err != nil {
		return hostnames, err
	}

	if resp.ResolveStatus != resolver.StatusEndpointNotExists && resp.EndpointSet != nil {
		for _, endpoint := range resp.EndpointSet.Endpoints {
			if endpoint.Ready {
				hostnames = append(hostnames, endpoint.FQDN)
			}
		}
	}
	return hostnames, nil
}

func (sd SD) fetchReals(serviceID string) ([]string, error) {
	var hostnames []string

	for _, cluster := range resolver.AvailableClusters {
		if hostnamesFromCluster, err := sd.fetchRealsFromOneCluster(serviceID, cluster); err == nil {
			hostnames = append(hostnames, hostnamesFromCluster...)
		}
	}
	return hostnames, nil
}
