# -*- encoding: utf-8 -*-
from random import choice


def escape_tskv_message(message):
    for search, replacement in [
            ('\\', '\\\\'),
            ('\t', r'\t'),
            ('\r', r'\r'),
            ('\n', r'\n'),
            ('\0', r'\0')]:
        message = message.replace(search, replacement)
    return message


def log_response(logger, response):
    if response is not None:
        logger.info(escape_tskv_message('%d %s' % (response.status_code, response.text)))


def generate_duty_message():
    return choice((
        u'Твоё дежурство началось',
        u'Привет! Пора дежурить!',
        u'Кто-то переключил на тебя дежурство. Я тут не причём.',
        u'Труба зовёт дежурить!',
        u'Диск сам себя не починит. Теперь тебе дежурить',
        u'С этого момента звонки мониторинга и тикеты - твои',
    ))
