cluster : disk_api

include:
  - units.nginx
  - units.statbox-push-client
  - units.logbackup
  - units.envoy-local-balancer
  - units.abyssync
  - units.hw_watcher

disk_api-files:
  - /etc/yandex/mpfs/admins_overrides.yaml
  - /etc/yandex/mpfs/disk_android_videounlim_alert.uids

disk_api-exec-files:
  - /usr/bin/mpfs.stat-requests.py
  - /usr/bin/nginx.api-stat-tskv.py
  - /usr/bin/mpfs-stat-http-requests.py
  - /usr/bin/mpfs_exception_stat.py
  - /usr/bin/telemost_request_parser.py
  - /usr/bin/telemost_client_stat.py
  - /usr/bin/telemost_handles_status.py


syslog-config-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/syslog-ng/conf-enabled/nginx-access.conf
      - /etc/syslog-ng/conf-enabled/nginx-error.conf

nginx-config-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/nginx/uwsgi_params_api
      - /etc/nginx/nginx.conf
      - /etc/nginx/ssl/https
      - /etc/nginx/ssl/intapi-https
      - /etc/nginx/ssl/yateam-https
      - /etc/nginx/sites-enabled/api.conf
      - /etc/nginx/sites-enabled/api-yateam.conf
      - /etc/nginx/sites-enabled/telemost-yateam.conf
      - /etc/nginx/sites-enabled/intapi.conf
      - /etc/nginx/sites-enabled/cloud-admin.conf
      - /etc/nginx/sites-enabled/20-loggiver3132.conf
      - /etc/nginx/conf.d/authnets.conf
      - /var/www/telemost-yateam/apple-app-site-association

nginx-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/logrotate.d/nginx

nginx-dirs:
  disk_api:
    dirs:
      - /var/log/nginx/mpfs
      - /var/spool/nginx/tmp
      - /var/spool/nginx/cache
      - /var/log/nginx/disk-admin

certificates:
  contents:
    cloud-api.yandex.net.pem: {{ salt.yav.get('sec-01cs1pmm8qaqm2vp313ycrf4yv[pem]') | json }}
    cloud-api.yandex.net.key: {{ salt.yav.get('sec-01cs1pmm8qaqm2vp313ycrf4yv[key]') | json }}
    cloud-api.yandex-team.ru.pem: {{ salt.yav.get('sec-01cs1pqsddt117nekbvn0hsmhj[pem]') | json }}
    cloud-api.yandex-team.ru.key: {{ salt.yav.get('sec-01cs1pqsddt117nekbvn0hsmhj[key]') | json }}
    intapi.disk.yandex.net.pem: {{ salt.yav.get('sec-01cs23sz5b7yh8zzp8t28ddtby[pem]') | json }}
    intapi.disk.yandex.net.key: {{ salt.yav.get('sec-01cs23sz5b7yh8zzp8t28ddtby[key]') | json }}
  packages: []

disk_api-yav-secrets: {{ salt.yav.get('sec-01cs9rcz4b1std399889pvm30d') | json }}

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-api.yaml

statbox-push-client-dirs:
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

nginx-tskv-format: ydisk-nginx-access-log-api

loggiver_port: 3333

{%- if salt['grains.get']('conductor:root_datacenter') in ('sas', 'vla') %}
random_comments_host: {{ ['comments04h.qloud.disk.yandex.net', 'comments26h.qloud.disk.yandex.net'][salt['random.seed'](2, hash=salt['grains.get']('id'))] }}
{%- elif salt['grains.get']('conductor:root_datacenter')  == 'iva' %}
random_comments_host: {{ ['comments02e.qloud.disk.yandex.net', 'comments03e.qloud.disk.yandex.net'][salt['random.seed'](2, hash=salt['grains.get']('id'))] }}
{%- elif salt['grains.get']('conductor:root_datacenter')  == 'myt' %}
random_comments_host: {{ ['comments01f.qloud.disk.yandex.net', 'comments05f.qloud.disk.yandex.net'][salt['random.seed'](2, hash=salt['grains.get']('id'))] }}
{%- endif %}

hw_watcher:
  reaction_on_failsafe_disk: bot

yarl:
  stage: disk-ratelimiter-stable-yarl
  du: yarl-root
