
cluster : disk_dataapi

include:
  - units.memcached
  - units.yandex-disk-zookeeper-client
  - units.yandex-disk-dataapi
  # - units.yandex-dataapi-meta
  - units.logbackup
  - units.statbox-push-client
  - units.nginx

disk_dataapi-exec-files:
  - /usr/bin/dataapi-clients-stat-tskv.py

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-dataapi.yaml

statbox-push-client-dirs:
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

# =======================

nginx-symlinks:
  disk_dataapi-symlinks:
      symlinks:
         /etc/nginx/sites-enabled/dataapi.conf: /etc/nginx/sites-available/dataapi.conf
         /etc/nginx/sites-enabled/datasync.conf: /etc/nginx/sites-available/datasync.conf

nginx-files:
  disk_dataapi:
    basedir: files/disk_dataapi
    files:
      - /etc/logrotate.d/nginx.conf

nginx-config-files:
  disk_dataapi:
    basedir: files/disk_dataapi
    files:
      - /etc/nginx/nginx.conf
      - /etc/nginx/sites-available/dataapi.conf
      - /etc/nginx/sites-available/datasync.conf

nginx-dirs:
  disk_dataapi:
    dirs:
      - /var/log/nginx/dataapi

nginx-monrun-files:
  - /etc/monrun/conf.d/nginx.conf

nginx-tskv-format: ydisk-nginx-access-log-dataapi

# =======================

certificates:
  contents:
{% if grains.get('yandex-environment') in ('stable', 'production') %}
    etc/nginx/ssl/datasync.yandex.net.pem: {{ salt.yav.get('sec-01cs1tm311xcfag7r90xj1pwmp[pem]') | json }}
    etc/nginx/ssl/datasync.yandex.net.key: {{ salt.yav.get('sec-01cs1tm311xcfag7r90xj1pwmp[key]') | json }}
{% else %}
    etc/nginx/ssl/datasync.yandex.net.pem: {{ salt.yav.get('sec-01e1y6bbcwn6wrrmwxq8jh9r9x[pem]') | json }}
    etc/nginx/ssl/datasync.yandex.net.key: {{ salt.yav.get('sec-01e1y6bbcwn6wrrmwxq8jh9r9x[key]') | json }}
{% endif %}
    etc/yandex/dataapi/dataapi/keys/dataapi-pgpass: {{ salt.yav.get('sec-01cs99s85d7hwkxmg10g6k2s6q[dataapi-pgpass-' + grains.get('yandex-environment') + ']') | json }}
  path: ""
  packages: []
  cert_owner: disk
