cluster: disk_db_aux

include:
  - units.statbox-push-client
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  - units.yandex-selfdns-client


mongodb:
  mongo_hack: False
  python3: False
  managed-database: True
  monrun:
    replica-lag-common: 60
    replica-lag-hidden: 4000
    lock-on-primary-only: True
    asserts-user: 'off'
    disk-read: 'off'
    disk-write: 'off'
    connections-available: '>20000'
    connections-current: '<20000'
    write-queue: 'off'
    read-queue: 'off'
  stock: True
  stock_repos: False
  version: 3.2.12+yadisk1
  rsyncd_secrets: {{ salt.yav.get('sec-01cs9e00xn1pbvhxjwdqzz5dwh[rsyncd.secrets]') | json }}

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-disk-db-aux-logstore.yaml

statbox-push-client-dirs:
  - /var/spool/push-client-logstore

{% if not ( grains['mongodb']['isArbiter'] or grains['mongodb']['isHidden'] ) %}
yabs-chkdisk:
  enabled: True
  needcall: True

free_memory:
  warn_limit_mb: 30720
  crit_limit_mb: 15360
{% else %}
free_memory:
  warn_limit_mb: 512 
  crit_limit_mb: 512 
{% endif %}
