cluster: disk_db_meta

include:
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  - units.yandex-selfdns-client

mongodb:
  mongo_hack: False
  python3: False
  managed-database: True
  monrun:
    replica-lag-common: 60
    replica-lag-hidden: 4000
    lock-on-primary-only: True
    asserts-user: 'off'
    disk-read: 'off'
    disk-write: 'off'
    connections-available: '>20000'
    connections-current: '<35000'
    write-queue: '<150'
    read-queue: '<150'
  rsyncd_secrets: {{ salt.yav.get('sec-01cs9e00xn1pbvhxjwdqzz5dwh[rsyncd.secrets]') | json }}


{% if not ( grains['mongodb']['isArbiter'] or grains['mongodb']['isHidden'] ) %}
free_memory:
  warn_limit_mb: 30720
  crit_limit_mb: 15360
{% else %}
free_memory:
  warn_limit_mb: 512
  crit_limit_mb: 512
{% endif %}
