cluster: disk_db_misc

include:
  - units.statbox-push-client
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  {% if 'RA' in grains['conductor']['tags'] %}
  - units.yandex-selfdns-client
  {% endif %}


mongodb:
  mongo_hack: False
  python3: False
  managed-database: True
  rsyncd_secrets: {{ salt.yav.get('sec-01cs9e00xn1pbvhxjwdqzz5dwh[rsyncd.secrets]') | json }}
  monrun:
    replica-lag-common: 60
    replica-lag-hidden: 4000
    lock-on-primary-only: True
    asserts-user: 'off'
    disk-read: 'off'
    disk-write: 'off'
    connections-available: '>20000'
    connections-current: '<38000'
    write-queue: '<150'
    read-queue: '<150'


disk_db_misc-files:
  - /etc/monitoring/watchdog.conf
  - /etc/monitoring/mongodb_indexes/conf.d/misc.json

disk_db_misc-exec-files:
  - /usr/local/bin/mongo-closer

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-disk-db-misc-logstore.yaml

statbox-push-client-dirs:
  - /var/spool/push-client-logstore

{% if not ( grains['mongodb']['isArbiter'] or grains['mongodb']['isHidden'] ) %}
yabs-chkdisk:
  enabled: True
  needcall: True

free_memory:
  warn_limit_mb: 30720
  crit_limit_mb: 15360
{% else %}
free_memory:
  warn_limit_mb: 512 
  crit_limit_mb: 512 
{% endif %}
