cluster: disk_db_sys

include:
  - units.statbox-push-client
  - units.mongodb
  - units.mongodb-mms-monitoring-agent
  - units.mongodb-mms-automation-agent
  - units.yandex-selfdns-client

mongodb:
  python3: False
  mongo_hack: False
  managed-database: True
  rsyncd_secrets: {{ salt.yav.get('sec-01cs9e00xn1pbvhxjwdqzz5dwh[rsyncd.secrets]') | json }}
  monrun:
    replica-lag-common: 60
    replica-lag-hidden: 4000
    connections-available: '>20000'
    connections-current: '<40000'
    asserts-user: 'off'

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-disk-db-sys-logstore.yaml

statbox-push-client-dirs:
  - /var/spool/push-client-logstore

{% if not ( grains['mongodb']['isArbiter'] or grains['mongodb']['isHidden'] ) %}
yabs-chkdisk:
  enabled: True
  needcall: True

free_memory:
  warn_limit_mb: 30720
  crit_limit_mb: 15360
{% else %}
free_memory:
  warn_limit_mb: 512 
  crit_limit_mb: 512 
{% endif %}
