
cluster : disk_downloader

include:
  - units.nginx
  - units.yandex-disk-downloader
  - units.statbox-push-client
  - units.fastcgi-blackbox-authorizer
  - units.logbackup
  - units.abyssync
  - units.hw_watcher

# ====== disk_downloader =======

disk_downloader-files:
  - /etc/tailer.conf
  - /etc/monitoring/unispace.conf
  - /etc/monitoring/watchdog.conf
  - /etc/free_space_watchdog/free_space_watchdog.conf
  - /var/lib/yandex-disk-downloader-hostlist/disk_downloader-net
  - /usr/share/yandex-configs/disk_downloader/downloader-tskv-access.exclude

disk_downloader-monrun-files:
  - /etc/monrun/conf.d/valid_traffic.conf
  - /etc/monrun/conf.d/cert_issuer.conf
  - /etc/monrun/conf.d/cert_date.conf

disk_downloader-exec-files:
  - /usr/share/free_space_watchdog/iptables-close-nginx.sh

parsers-bin:
  - lenulca2tskv.py
  - mulcagate.stat-access.py

disk_downloader-additional_pkgs:
  - psmisc
  - util-linux

disk_downloader-symlinks:
  /etc/nginx/sites-enabled/hostlist.conf: /etc/nginx/sites-available/hostlist.conf

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-downloader.yaml 

statbox-push-client-dirs:
  - /var/spool/push-client-mulca
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

# ======= nginx ======= #

nginx-files:
  disk_downloader:
    basedir: files/disk_downloader
    files:
      - /etc/logrotate.d/nginx.conf

nginx-config-files:
  disk_downloader:
    basedir: files/disk_downloader
    files:
      - /etc/nginx/nginx.conf
      - /etc/nginx/disk/include/proxy_cache_path.include 
      - /etc/nginx/sites-available/hostlist.conf

nginx-dirs:
  disk_downloader:
    dirs:
      - /var/log/nginx/downloader
      - /u0/nginx/tmp
      - /u0/nginx/cache_preview
      - /u0/nginx/cache

nginx-monrun-files:
  - /etc/monrun/conf.d/nginx.conf

certificates:
  contents:
  {%- if grains.get('yandex-environment') in ('stable', 'production') %}
    disk.yandex.ru.crt: {{ salt.yav.get('sec-01crzdzb4khf7xa1mwf88g4680[pem]') | json }}
    disk.yandex.ru.key: {{ salt.yav.get('sec-01crzdzb4khf7xa1mwf88g4680[key]') | json }}
  {%- else %}
    disk.yandex.ru.crt: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[pem]') | json }}
    disk.yandex.ru.key: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[key]') | json }}
  {%- endif %}
  path: /etc/yamail/ssl
  packages: []
  cert_owner: root

tvmtool-conf: {{ salt.yav.get('sec-01cs9pxn0nafk0exs4s8454ztr[tvmtool.conf]') | json }}
disk-secret-keys: {{ salt.yav.get('sec-01cs9ygv7bjy1kp0dv76by3xk0') | json }}

mulcagate:
    client_chunk_size: 438860
    put:
       pool_size: 350
       pool_threads: 100
       streaming_threshold: 51242880
    conf_get:
       pool_size: 500
       pool_threads: 200
    del:
       pool_size: 350
       pool_threads: 100
    redirect_enabled: true
    redirect_options:
       redirect_sign_token: 'd99cb65d207c46'
       redirect_expire: 14400
       redirect_min_expire: 60
       redirect_blob_path_prefix: '/srv/storage'
       mulca_write_enabled: 0
    elliptics:
      libmds:
        thread_num: 2
        redirect_check_port: 8090
        redirect_check_query: '?service=disk_downloader_mulcagate'
        redirect_check_timeout_ms: 5000
      auth: true
      elliptics_auth_options: 2000273
    cache: true
    cache_options:
       uri: 'http://units.mail.yandex.net:80/top_stids.txt'
       update_interval: 30
       connect_timeout: 2
       read_timeout: 5

mediastorage-mulcagate:
  http_check:
    service: 'disk_downloader_mulcagate'
  tls:
    support: 1

hw_watcher:
  reaction_on_failsafe_disk: bot

#tls_elliptics: {{salt.yav.get('sec-01dz16gr5cpgzv5hh5ya7gmz8k')|json}}
#tls_karl: {{salt.yav.get('sec-01efkqdwhc1q1aj4ga53cp0r37')|json}}
