cluster : disk_grant

include:
  - units.nginx
  - units.statbox-push-client

nginx-config-files:
  disk_grant:
    basedir: files/disk_grant
    files:
      - /etc/nginx/nginx.conf
      - /etc/nginx/sites-available/10-grant.conf

nginx-files:
  disk_grant:
    basedir: files/disk_grant
    files:
      - /etc/logrotate.d/nginx
      - /etc/nginx/grant/htpasswd_staff
      - /etc/nginx/grant/htpasswd_yaru
      - /etc/nginx/grant/htpasswd_itroot

nginx-dirs:
  disk_grant:
    dirs:
      - /var/log/nginx/
      - /var/spool/nginx/client-temp


nginx-monrun-files:
  - /etc/monrun/conf.d/nginx.conf

nginx-symlinks:
  disk_grant:
    symlinks:  
      /etc/nginx/sites-enabled/10-grant.conf: /etc/nginx/sites-available/10-grant.conf

nginx-tskv-format: ydisk-nginx-access-log-grant

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-grant.yaml

statbox-push-client-dirs:
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True
