cluster: disk_mpfs

include:
  - units.mpfs
  - units.mpfs-core-uwsgi-disk
  - units.statbox-push-client
  - units.nginx
  - units.logbackup
  - units.yandex-disk-log-reader
  - units.yandex-disk-zookeeper-client
  - units.envoy-local-balancer
  - units.abyssync
  - units.hw_watcher

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-mpfs.yaml
#  - /etc/yandex/statbox-push-client/push-client-mpfs-logstore.yaml
#  - /etc/yandex/statbox-push-client/push-client-mpfs-elastic.yaml

statbox-push-client-dirs:
#  - /var/spool/push-client-elastic
#  - /var/spool/push-client-logstore
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

disk_mpfs-files:
  - /etc/cron.d/mpfs-queue-restart

nginx-files:
  disk-mpfs:
    basedir: files/disk_mpfs
    files:
      - /etc/nginx/conf.d/01-mpfs-tskv-log.conf

nginx-tskv-format: mpfs-access-log

mongodb:
  python3: False
  mongo_hack: False
  version: '1:2.6.9.yandex1'
  mongod: False

certificates:
  contents:
    mpfs.disk.yandex.net.pem: {{ salt.yav.get('sec-01cs1n3sfg73p2fkh7qp4wpy0n[pem]') | json }}
    mpfs.disk.yandex.net.key: {{ salt.yav.get('sec-01cs1n3sfg73p2fkh7qp4wpy0n[key]') | json }}
  packages: []

hw_watcher:
  reaction_on_failsafe_disk: bot
