cluster : disk_qa_api

include:
  - units.nginx
  - units.statbox-push-client
  - units.abyssync
  - units.envoy-local-balancer


disk_qa_api-files:
  - /etc/yandex/mpfs/admins_overrides.yaml

syslog-config-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/syslog-ng/conf-enabled/nginx-access.conf
      - /etc/syslog-ng/conf-enabled/nginx-error.conf

nginx-config-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/nginx/uwsgi_params_api
      - /etc/nginx/nginx.conf
      - /etc/nginx/ssl/https
      - /etc/nginx/ssl/intapi-https
      - /etc/nginx/ssl/yateam-https
      - /etc/nginx/sites-enabled/api.conf
      - /etc/nginx/sites-enabled/intapi.conf
      - /etc/nginx/sites-enabled/telemost-yateam.conf
      - /etc/nginx/conf.d/authnets.conf
      - /etc/nginx/sites-enabled/cloud-admin.conf
      - /etc/nginx/sites-enabled/20-loggiver3132.conf

nginx-files:
  disk_api:
    basedir: files/disk_api
    files:
      - /etc/logrotate.d/nginx

nginx-dirs:
  disk_api:
    dirs:
      - /var/log/nginx/mpfs
      - /var/log/nginx/disk-admin

certificates:
  contents:
    cloud-api.yandex.net.pem: {{ salt.yav.get('sec-01cs1pjx7yh44707tptf8s7sfx[pem]') | json }}
    cloud-api.yandex.net.key: {{ salt.yav.get('sec-01cs1pjx7yh44707tptf8s7sfx[key]') | json }}
    cloud-api.yandex-team.ru.pem: {{ salt.yav.get('sec-01cs1pqsddt117nekbvn0hsmhj[pem]') | json }}
    cloud-api.yandex-team.ru.key: {{ salt.yav.get('sec-01cs1pqsddt117nekbvn0hsmhj[key]') | json }}
    intapi.disk.yandex.net.pem: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[pem]') | json }}
    intapi.disk.yandex.net.key: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[key]') | json }}
  packages: []

disk_api-yav-secrets: {{ salt.yav.get('sec-01cs9rcz4b1std399889pvm30d') | json }}

# ======= statbox-push-client =======

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-api-qa.yaml

statbox-push-client-dirs:
  - /var/spool/push-client

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

disk_qa_api-exec-files:
  - /usr/bin/mpfs.stat-requests.py
  - /usr/bin/nginx.api-stat-tskv.py
