cluster: disk_queue

include:
  - units.rabbitmq-server
  - units.logbackup

rabbitmq-server-vhosts:
  - mqueue-vhost

rabbitmq-server-users:
  mqueue-user:
  {%- if grains.get('yandex-environment') in ('stable', 'production') %}
    password: {{ salt.yav.get('sec-01cs9aw4qq3c0f7jtvad5c920g[rabbitmq-password-stable]') | json }}
  {%- else %}
    password: {{ salt.yav.get('sec-01cs9aw4qq3c0f7jtvad5c920g[rabbitmq-password-prestable]') | json }}
  {%- endif %}
    tags: 
      - management
    perms:
      mqueue-vhost:
        - '.*'
        - '.*'
        - '.*'

rabbitmq-server-plugins:
  - rabbitmq_management

rabbitmq-server-dirs:
  disk_mqueue:
    dirs:
      - /u0/rabbitmq

certificates:
  contents:
    {%- if grains.get('yandex-environment') in ('stable', 'production') %}
      rabbitmq-vhost-access.yaml: {{ salt.yav.get('sec-01cs9aw4qq3c0f7jtvad5c920g[rabbitmq-vhost-access.yaml]') | json }}
    {%- else %}
      rabbitmq-vhost-access.yaml: {{ salt.yav.get('sec-01cs9aw4qq3c0f7jtvad5c920g[rabbitmq-vhost-access.yaml-prestable]') | json }}
    {%- endif %}
  path: /etc/monitoring
  packages: []
  cert_owner: www-data

{% if grains['id'] == 'queue03e.disk.yandex.net' or grains['id'] == 'queue02f.disk.yandex.net' %}
hw_watcher:
  partition_alignment_status: ok
{% endif %}

