
cluster : disk_uploader

include:
  - units.yandex-disk-uploader
  # - units.esets
  - units.nginx
  - units.statbox-push-client
  - units.sophos
  - units.office
  - units.logbackup
  - units.yandex-disk-zookeeper-client
  - units.hw_watcher
  - units.yavs-docker

parsers-bin:
  - elliptics_client_parser.py
  - mulcagate.stat-libmulca.py
  - mulcagate.stat-access.py
  - lenulca2tskv.py

# =======================

disk_uploader-files:
  - /etc/tailer.conf
  - /etc/monitoring/unispace.conf
  - /etc/ImageMagick/policy.xml
  - /etc/ImageMagick-6/policy.xml
  - /usr/share/yandex-configs/disk_uploader/uploader-access.exclude
  - /usr/share/yandex-configs/disk_uploader/uploader-access-tskv.exclude
  - /etc/init/syslog-ng.override
  - /etc/ubic/service/yandex-disk-uploader.ini

disk_uploader-monrun-files:
  - /etc/monrun/conf.d/valid_traffic.conf
  - /etc/monrun/conf.d/cert_issuer.conf
  - /etc/monrun/conf.d/cert_date.conf
  - /etc/monrun/conf.d/cert_expires.conf

disk_uploader-exec-files:
  - /usr/bin/disk_uploader.traf.sh
  - /usr/bin/disk_uploader.valid_traffic.sh

disk_uploader-additional_pkgs:
  - psmisc
  - util-linux

disk_uploader-symlinks:
  /etc/nginx/sites-enabled/uploader.conf: /etc/nginx/sites-available/uploader.conf

# =======================

statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-uploader.yaml
  - /etc/yandex/statbox-push-client/push-client-uploader-mulca.yaml

statbox-push-client-dirs:
  - /var/spool/push-client-mulca
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

# =======================

nginx-files:
  disk_uploader:
    basedir: files/disk_uploader
    files:
      - /etc/logrotate.d/nginx.conf

nginx-config-files:
  disk_uploader:
    basedir: files/disk_uploader
    files:
      - /etc/nginx/nginx.conf
      - /etc/nginx/sites-available/uploader.conf
      - /etc/nginx/conf.d/upstreams.conf

nginx-dirs:
  disk_uploader:
    dirs:
      - /var/log/nginx/uploader
      - /var/log/nginx/office

nginx-monrun-files:
  - /etc/monrun/conf.d/nginx.conf


certificates:
  contents:
  {%- if grains.get('yandex-environment') in ('stable', 'production') %}
    disk_uploader.crt: {{ salt.yav.get('sec-01cs23sz5b7yh8zzp8t28ddtby[pem]') | json }}
    disk_uploader.key: {{ salt.yav.get('sec-01cs23sz5b7yh8zzp8t28ddtby[key]') | json }}
  {%- else %}
    disk_uploader.crt: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[pem]') | json }}
    disk_uploader.key: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[key]') | json }}
  {%- endif %}
    office.disk.yandex.net.crt: {{ salt.yav.get('sec-01cs23vfv572y93x1g93a93bj9[pem]') | json }}
    office.disk.yandex.net.key: {{ salt.yav.get('sec-01cs23vfv572y93x1g93a93bj9[key]') | json }}
  path: /etc/yandex/disk/uploader/keys/
  packages: []
  cert_owner: root

mulcagate:
    client_chunk_size: 4388600
    elliptics:
      timeout:
        default: 5
        read: 60
        write: 600
        remove: 200
        lookup: 2
      mastermind:
        update_period: 60
        expire_time: 143200
      auth: true
      elliptics_auth_options: 2000273
    put:
       pool_size: 350
       pool_threads: 100
       streaming_threshold: 51242880
    conf_get:
       pool_size: 500
       pool_threads: 200
    del:
       pool_size: 350
       pool_threads: 100
    redirect_enabled: false
    cache: false

mediastorage-mulcagate:
  chunk_size:
    read: 4
    write: 4
  tls:
    support: 1

nginx-tskv-format: ydisk-nginx-access-log-uploader

hw_watcher:
  reaction_on_failsafe_disk: bot
  ssd_wearout_threshold: 2

zk:
  username: uploader
  password: {{ salt.yav.get('sec-01d94ndjebe70xzz8vsn7zc4zs[zk_uploader_password]') | json }}

tls_elliptics: {{salt.yav.get('sec-01dz16gr5cpgzv5hh5ya7gmz8k')|json}}
tls_karl: {{salt.yav.get('sec-01efkqdwhc1q1aj4ga53cp0r37')|json}}
