cluster : disk_webdav

include:
  - units.yadrop
  - units.statbox-push-client
  - units.logbackup

disk_webdav-files:
  - /var/www/share/dist/YandexCA.p7b
  - /var/www/share/dist/Certum.p7b

disk_webdav-config-files:
  - /etc/yandex/yadrop/app.config-production

parsers-bin:
  - lenulca2tskv.py

disk_webdav-extra-pkgs: 
  - pigz
  - htop

nginx-config-files:
  disk_webdav:
    basedir: files/disk_webdav
    files:
      - /etc/nginx/sites-enabled/10-webdav.yandex.ru.conf
      - /etc/nginx/conf.d/01-webdav-tskv-log.conf
      - /etc/nginx/nginx.conf

nginx-dirs:
  disk_webdav:
    dirs:
      - /var/log/nginx/mpfs
      - /var/spool/nginx/cache



certificates:
  contents:
  {%- if grains.get('yandex-environment') in ('stable', 'production') %}
    webdav.yandex.ru.pem: {{ salt.yav.get('sec-01cs24q5c3jcpq3aky56smbmrh[pem]') | json }}
    webdav.yandex.ru.key: {{ salt.yav.get('sec-01cs24q5c3jcpq3aky56smbmrh[key]') | json }}
  {%- else %}
    webdav.yandex.ru.pem: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[pem]') | json }}
    webdav.yandex.ru.key: {{ salt.yav.get('sec-01cs1mtvq55csc2psxb03cp1rw[key]') | json }}
  {%- endif %}
    CertumCA.pem: {{ salt.yav.get('sec-01crz1mn3chz0q6gdcasf0bn40[pem]') | json }}
    YandexCA.pem: {{ salt.yav.get('sec-01crz1gz4xn66px062dr2rt7nz[pem]') | json }}
    YandexInternalCA.pem: {{ salt.yav.get('sec-01crz1js872tjx9ypct2xf8pbp[pem]') | json }}
  path: /etc/yamail/ssl
  packages: []
  cert_owner: yadrop


statbox-push-client-config-files:
  - /etc/yandex/statbox-push-client/push-client-webdav.yaml
#  - /etc/yandex/statbox-push-client/push-client-webdav-logstore.yaml
  - /etc/yandex/statbox-push-client/push-client-webdav-mulca.yaml

statbox-push-client-dirs:
  - /var/spool/push-client-logstore
  - /var/spool/push-client-elastic
  - /var/spool/push-client-mulca
  - /var/spool/push-client

statbox-push-client_logs_status_check:
  enabled: True

statbox-push-client_tvm-secret: {{ salt.yav.get('sec-01e9fpey3z450g408453aa0hrc[client_secret]') | json }}

mongodb:
  mongos:
    watchdog: True

mulcagate:
    client_chunk_size: 438860
    put:
       pool_size: 350 
       pool_threads: 100 
       streaming_threshold: 51242880
    conf_get:
       pool_size: 500 
       pool_threads: 200 
    del:
       pool_size: 350 
       pool_threads: 100 
    redirect_enabled: false
    redirect_options:
       redirect_sign_token: 'd99cb65d207c46'
       redirect_expire: 14400
       redirect_min_expire: 60
       redirect_blob_path_prefix: '/srv/storage'
       mulca_write_enabled: 0
    cache: true
    cache_options:
       uri: 'http://units.mail.yandex.net:80/top_stids.txt'
       update_interval: 30
       connect_timeout: 2
       read_timeout: 5
    elliptics:
      auth: true
      elliptics_auth_options: 2000273

mediastorage-mulcagate:
  http_check:
    service: 'disk_webdav_mulcagate'
  tls:
    support: 1

hw_watcher:
  reaction_on_failsafe_disk: bot

tls_elliptics: {{salt.yav.get('sec-01dz16gr5cpgzv5hh5ya7gmz8k')|json}}
tls_karl: {{salt.yav.get('sec-01efkqdwhc1q1aj4ga53cp0r37')|json}}
