{% set unit = 'clickhouse' %}

data:
  clickhouse:
    users:
      logshatter:
        password: {{ salt.yav.get('sec-01des5naa6mjr5q1rk0fa9c7wf[logshatter.password]') | json }}
        profile: logshatter_profile
      yql_logreader:
        password: {{ salt.yav.get('sec-01des5naa6mjr5q1rk0fa9c7wf[yql_logreader.password]') | json }}
        profile: readonly
    internal_users:
      interserver:
        password: {{ salt.yav.get('sec-01des5naa6mjr5q1rk0fa9c7wf[interserver.password]') | json }}
    shard_id: {{'shard' + salt['grains.get']('id').split('.')[0][-3:-1] }}

{{ unit }}-files:
  - /etc/clickhouse-server/users.xml
  - /etc/clickhouse-server/config.xml
  - /etc/clickhouse-server/cluster.xml


{{ unit }}-monrun-files:
  - /etc/monrun/conf.d/clickhouse.conf

{{ unit }}-exec-files:
  - /usr/local/yandex/monitoring/ch_log_errors.sh
  - /usr/local/yandex/monitoring/ch_ping.py
