{% set unit = 'mongodb-mms' %}


{{ unit }}-exec-files:
  - /opt/mongodb/mms/bin/mongodb-mms
  - /usr/bin/opsm.stat-access.py

{{ unit }}-config-files:
  - /opt/mongodb/mms/conf/conf-mms.properties
  - /etc/mongodb-mms/gen.key


### nginx

nginx-files:
  {{unit}}:
    basedir: units/{{unit}}/files
    files:
      - /etc/logrotate.d/nginx-opsm

nginx-dirs:
  {{unit}}:
    dirs:
      - /var/log/nginx/opsm
      - /var/spool/nginx/cache

nginx-config-files:
  {{unit}}:
    basedir: units/{{unit}}/files
    files:
      - /etc/nginx/nginx.conf
      - /etc/nginx/sites-available/30-opsm.conf

nginx-symlinks:
  {{unit}}:
    symlinks:
      /etc/nginx/sites-enabled/30-opsm.conf: /etc/nginx/sites-available/30-opsm.conf

