{% set unit = 'yandex-disk-uploader' %}

{{ unit }}-files:
  - /etc/cron.d/yandex-disk-uploader-meta
  - /etc/cron.d/fstrim

{{ unit }}-monrun-files:
  - /etc/monrun/conf.d/uploader-sensors-stats.conf
  - /etc/monrun/conf.d/uploader-events-stats.conf
  - /etc/monrun/conf.d/uploader-access-stats.conf

{{ unit }}-exec-files:
  - /usr/bin/disk_uploader.uploader-sensors.py
  - /usr/bin/disk_uploader.uploader-access.py
  - /usr/bin/disk_uploader.uploader-events.py
  - /usr/bin/uploader-access-parser.py
  - /usr/bin/uploader.stat-access.py
  - /usr/bin/ngx_errlog_parser.py
  - /etc/network/if-up.d/yandex-jumbo
  - /usr/local/bin/cron_fstrim.sh

  - /usr/lib/yandex-graphite-checks/available/uploader-events.sh
  - /usr/lib/yandex-graphite-checks/available/uploader-access.sh
  - /usr/lib/yandex-graphite-checks/available/uploader-access-preview-1s.sh
  - /usr/lib/yandex-graphite-checks/available/uploader-sensors.sh

{{ unit }}-config-files:
  - /etc/yandex/disk/uploader/application.properties

{{ unit }}-symlinks:
  /usr/lib/yandex-graphite-checks/enabled/uploader-events.sh: /usr/lib/yandex-graphite-checks/available/uploader-events.sh
  /usr/lib/yandex-graphite-checks/enabled/uploader-access.sh: /usr/lib/yandex-graphite-checks/available/uploader-access.sh
  /usr/lib/yandex-graphite-checks/enabled/uploader-access-preview-1s.sh: /usr/lib/yandex-graphite-checks/available/uploader-access-preview-1s.sh
  /usr/lib/yandex-graphite-checks/enabled/uploader-sensors.sh: /usr/lib/yandex-graphite-checks/available/uploader-sensors.sh

{{ unit }}-application-secret-properties: {{ salt.yav.get('sec-01cs9pesj413cqkj34tejmt7xn[application-secret.properties]') | json }}
