{% set cluster = pillar.get('cluster') %}

include:
  - units.monrun.rsyncd

{% for file in pillar.get('disk-backup-config-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True
{% endfor %}

{% for file in pillar.get('disk-backup-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True
{% endfor %}

/etc/rsyncd.secrets:
  file.managed:
    - contents: "disk:{{ pillar['rsyncd_password'] }}"
    - mode: 600
    - user: root
    - group: root
    - makedirs: True
    - follow_symlinks: True

rsync:
  service:
    - running
    - reload: True

/u0/backup-cassandra/:
  file.directory:
    - user: root
    - group: root
    - mode: 755
    - makedirs: True
/u0/backup-zookeeper/:
  file.directory:
    - user: root
    - group: root
    - mode: 755
    - makedirs: True
/u0/backup-zookeeper-pgsync/:
  file.directory:
    - user: root
    - group: root
    - mode: 755
    - makedirs: True
/u0/backup-zookeeper-logshatter/:
  file.directory:
    - user: root
    - group: root
    - mode: 755
    - makedirs: True


backup-zookeeper:
  monrun.present:
    - command: '/usr/bin/check_zookeeper_backup.sh zookeeper 1700'

backup-zookeeper-pgsync:
  monrun.present:
    - command: '/usr/bin/check_zookeeper_backup.sh zookeeper-pgsync 140'

backup-zookeeper-logshatter:
  monrun.present:
    - command: '/usr/bin/check_zookeeper_backup.sh zookeeper-logshatter 140'
