
{% set cluster = pillar.get('cluster') %}
include:
  - templates.certificates
  - units.loggiver



/etc/nginx/sites-enabled/log.conf:
  file.managed:
    - source: salt://files/disk_log/etc/nginx/sites-enabled/log.conf
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
/etc/nginx/nginx.conf:
  file.managed:
    - source: salt://files/disk_log/etc/nginx/nginx.conf
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
/etc/logrotate.d/nginx:
  file.managed:
    - source: salt://files/disk_log/etc/logrotate.d/nginx
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
/etc/cron.d/wd-push-server:
  file.managed:
    - source: salt://files/disk_log/etc/cron.d/wd-push-server
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
/etc/cron.d/log-clean:
  file.managed:
    - source: salt://files/disk_log/etc/cron.d/log-clean
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - watch_in: monrun-regenerate
/u0/disk_logs/:
  file.directory:
    - user: www-data
    - group: www-data
    - mode: 755
    - makedirs: True

{% for file in pillar.get('disk-log-server') %}
{{file}}:
  file.managed:
    - source: salt://files/disk_log{{file}}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

nginx:
  service:
    - running
    - reload: True
    - require:
      - pkg: nginx
    - watch:
      - file: /etc/nginx/nginx.conf
      - file: /etc/nginx/sites-enabled/log.conf
  pkg:
    - installed
    - pkgs:
      - nginx
      - nginx-common
      - nginx-full
push-server:
  service:
    - running
