{% set cluster = pillar.get('cluster') %}

include:
  - units.nginx
  - units.nginx.tskv
  - templates.certificates
  - units.syslog-ng
  - units.statbox-push-client
  - units.loggiver
  - units.logbackup
  - units.logrotate-random
  - templates.ipvs_tun
  - templates.media-tskv.parsers
  - units.deploy-checks
  - units.envoy-local-balancer
  - units.abyssync
  - units.hw_watcher
#  - units.yarl

{% for file in pillar.get(cluster + '-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 644
    - user: root
    - group: root
    - makedirs: True
    - template: jinja
{% endfor %}

{% for file in pillar.get( cluster + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755 
    - user: root
    - group: root
    - makedirs: True
{% endfor %}


cert_date:
  monrun.present:
    - execution_interval: 60
    - command: '/usr/lib/config-monrun-cert-check/cert_expires.sh' 

cert_issuer:
  monrun.present:
    - execution_interval: 60
    - command: '/usr/lib/config-monrun-cert-check/cert_check_extended.sh -h localhost -p 443 -i "Yandex CA"'


monrun-mpfs-api:
  monrun.present:
    - name: mpfs-api
    - execution_interval: 10
    - command: '/usr/bin/http_check.sh ping 80'

monrun-mpfs-intapi:
  monrun.present:
    - name: mpfs-intapi
    - execution_interval: 10
    - command: '/usr/bin/http_check.sh ping 8080'

mpfs-extapi-uwsgi:
    service:
          - running

mpfs-intapi-uwsgi:
    service:
          - running

monrun-lighttpd_3132:
  monrun.present:
    - name: lighttpd_3132
    - file: /etc/monrun/conf.d/lighttpd3132.conf
    - execution_interval: 300
    - command: '/usr/bin/http_check.sh ping_pattern {{ pillar.get('loggiver_port') }}'


/etc/nginx/keys/tvm-asymmetric.public:
  file.managed:
    - contents_pillar: disk_api-yav-secrets:tvm-asymmetric.public
    - mode: 440 
    - user: root
    - group: nginx
    - makedirs: True


/etc/yandex/disk-secret-keys.yaml:
  file.managed:
    - contents_pillar: disk_api-yav-secrets:disk-secret-keys.yaml
    - mode: 440 
    - user: root
    - group: nginx
    - makedirs: True


/etc/yandex/mpfs/access_overrides.yaml:
  file.managed:
    - contents_pillar: disk_api-yav-secrets:access_overrides.yaml
    - mode: 440
    - user: root
    - group: nginx
    - makedirs: True
