{% set cluster = pillar.get('cluster') %}

include:
  - units.memcached
  - units.yandex-disk-zookeeper-client
  - units.yandex-disk-dataapi
  # - units.yandex-dataapi-meta
  - units.logbackup
  - units.loggiver
  - units.statbox-push-client
  - units.nginx
  - units.nginx.tskv
  - units.logrotate-random
  - templates.certificates
  - templates.media-tskv.parsers
  - templates.ipvs_tun

{% for file in pillar.get( cluster + '-exec-files') %}
{{file}}:
  yafile.managed:
    - source: salt://files/{{ cluster }}{{ file }}
    - mode: 755
    - user: root
    - group: root
    - makedirs: True
{% endfor %}

